/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketColumnPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketFilterPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketGeneralWizardPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketQueueQueryPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.dialog.wizard.VWBaseWizardDialog;
import java.awt.Component;

public class VWNewWorkBasketWizard
extends VWBaseWizardDialog {
    private VWSessionInfo m_sessionInfo = null;
    private VWDataDictionary m_dataDictionary = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private VWWorkBasketColumnPanel m_workBasketColumnPanel = null;
    private VWWorkBasketQueueQueryPanel m_workBasketQueueQueryPanel = null;
    private VWWorkBasketFilterPanel m_workBasketFilterPanel = null;

    public VWNewWorkBasketWizard(VWSessionInfo sessionInfo, VWDataDictionary dataDictionary) {
        super(sessionInfo.getParentFrame());
        this.m_sessionInfo = sessionInfo;
        this.m_dataDictionary = dataDictionary;
        this.initialize(VWImageLoader.createImageIcon("workBasketWizard32.gif"));
    }

    public VWWorkBasketDefinition getWorkBasketDefinition() {
        return this.m_workBasketDef;
    }

    public void releaseResources() {
        this.m_sessionInfo = null;
        super.releaseResources();
    }

    protected void addPanels() {
        this.m_panelList = new IVWWizardPanel[4];
        int nPanelIndex = 0;
        int nTypes = 3;
        VWQueueDefinition[] queueDefs = this.m_dataDictionary.getQueueDefinitions(nTypes);
        VWWorkBasketGeneralWizardPanel panel = new VWWorkBasketGeneralWizardPanel(this, queueDefs);
        this.m_mainPanel.add((Component)panel, panel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = panel;
        this.m_workBasketColumnPanel = new VWWorkBasketColumnPanel(this.m_sessionInfo, true);
        this.m_mainPanel.add((Component)this.m_workBasketColumnPanel, this.m_workBasketColumnPanel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = this.m_workBasketColumnPanel;
        this.m_workBasketFilterPanel = new VWWorkBasketFilterPanel(this.m_sessionInfo);
        this.m_mainPanel.add((Component)this.m_workBasketFilterPanel, this.m_workBasketFilterPanel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = this.m_workBasketFilterPanel;
        this.m_workBasketQueueQueryPanel = new VWWorkBasketQueueQueryPanel(this.m_sessionInfo, true);
        this.m_mainPanel.add((Component)this.m_workBasketQueueQueryPanel, this.m_workBasketQueueQueryPanel.getUniqueIdentifier());
        this.m_panelList[nPanelIndex++] = this.m_workBasketQueueQueryPanel;
    }

    protected String getDialogDimensionString() {
        return "665,555";
    }

    protected String getDialogTitle() {
        return VWResource.WorkBasketWizardTitle;
    }

    protected String getHelpPage() {
        return VWHelp.Help_Process_Config + "bpfc029.htm#";
    }

    protected boolean performFinishAction() {
        return true;
    }

    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            this.m_workBasketDef = workBasketDef;
            if (this.m_workBasketColumnPanel != null) {
                this.m_workBasketColumnPanel.setWorkBasketDefinition(workBasketDef);
            }
            if (this.m_workBasketQueueQueryPanel != null) {
                this.m_workBasketQueueQueryPanel.setWorkBasketDefinition(workBasketDef);
            }
            if (this.m_workBasketFilterPanel != null) {
                this.m_workBasketFilterPanel.setWorkBasketDefinition(workBasketDef);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        try {
            if (this.m_workBasketColumnPanel != null) {
                this.m_workBasketColumnPanel.setQueueDefinition(queueDef);
            }
            if (this.m_workBasketQueueQueryPanel != null) {
                this.m_workBasketQueueQueryPanel.setQueueDefinition(queueDef);
            }
            if (this.m_workBasketFilterPanel != null) {
                this.m_workBasketFilterPanel.setQueueDefinition(queueDef);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

